' Declaration des constantes
' ***************************
' Accel/decel des mouvement moteur
const ACCEL = 10    'KHz/s
' Timeout reception DMX provoquant l'arret des mouvements et l'activation du frein
const TIMEOUT_DMX = 2000    ' (ms)

' Adresses DMX
const DMX_ON_OFF = 1      ' Adresses Marche/arrêt sortie OUT1

const DMX_V1   = 2        ' Adresses Vitesse moteur 1
const DMX_POS1 = 3        ' Adresses Position moteur 1

'Sauvegarde position et vitesse moteur 1
V1=0
POS1=0   

' ***************************************************************
Initialisation:
   OUTALL 0
   Pause 300   

   Unlock


' Boucle programme principal
Do

  ' L'entree ENABLE a ete coupee (ex : arrêt d'urgence)
  if stsbit(8)=1 then goto Initialisation

  ' Gestion timeout reception DMX 
  if IsDMXReceived then
    SetUserMem 0, GetUserMem(0) + 1   ' Compteur reception DMX
    DMXReceived = 1
    TimerTimoutDMX = Timer + TIMEOUT_DMX
    TimeoutDMX = 0
  else
    DMXReceived = 0
  endif

  ' Detection d'un timeout de reception DMX
  if Timer > TimerTimoutDMX and not TimeoutDMX then
    ? "Timeout DMX"
    TimeoutDMX = 1
    ' Action à faire si pas de reception DMX pendant plus de TIMEOUT_DMX(ms)
  endif
  
  
  if DMXReceived then    ' Si nouvelles commandes DMX    
    ' Si canal DMX_ON_OFF > 127, activer sortie 1, sinon, désactiver sortie 1
    if GetDMX(DMX_ON_OFF)>127 then
      OUT 1, 1
    else
      OUT 1, 0
    endif
    
    ' Traitement des canaux 2 et 3 correspondant à Vitesse et position de l'axe 1
    newV1 = GetDMX(DMX_V1)
    newPOS1=GetDMX(DMX_POS1)
    if NewV1 <> V1 or newPOS1 <> POS1 then
      if V1 = 0 then 
        StopAxes 1
      else
        frequence = NewV1 * 10    ' transformation Valeur DMX 0..255 en fréquence de 0 à 2550Hz
        Position = NewPOS1 * 100   ' transformation Valeur DMX 0..255 en pas moteur de 0 à 255000pas
        moveaxe 1, ACCEL, frequence, ACCEL, Position
      endif
      V1 = NewV1
      POS1 = NewPOS1
    endif
  endif

Loop