
from ast import Index, Lambda
from calendar import c
from cgitb import text
from distutils.cmd import Command
from importlib.resources import path
from math import ceil
from msilib import RadioButtonGroup
from multiprocessing.connection import Client
from tkinter import *
import struct
from tkinter import messagebox
from turtle import color, goto, setposition


import pymodbus
from array import *

from time import sleep, perf_counter
from threading import Thread
from pygcode.line import Line
from tkinter import Tk    
from tkinter.filedialog import askopenfilename

#from pymodbus.compat import iteritems
from pymodbus.constants import Endian


from pymodbus.client.sync import ModbusSerialClient as ModbusClient
from pymodbus.client.sync import ModbusTcpClient as ModbusClient
import inspect
import logging
import schedule
import time
logging.basicConfig()
log = logging.getLogger()
log.setLevel(logging.INFO)


#client =ModbusClient("192.168.10.236", 502)


#region constantes

#CMD command code codes
Clear_alarm = 88,
Resume_feed_hold = 129
Feed_hold = 130
Stop_jog_mouvement = 133
Reset_speed_override = 138
Reset_rapide_speed_override = 143   
Reset_spindle_speed_override = 153  
Stop_and_flush = 255

#COILS Bits
REG_COIL_START = 0
MB_COIL_ADDR_OUTPUT0 = REG_COIL_START + 0


#HOLDING REGISTERS
REG_HOLDING_START = 2000
MB_HOLD_ADDR_AOUT0 = REG_HOLDING_START + 150
MB_HOLD_ADDR_CMD_BUFFER0 = (REG_HOLDING_START + 0)
MB_HOLD_ADDR_CMD_BUFFER149 = (MB_HOLD_ADDR_CMD_BUFFER0 + 149)


ICNC_MB_CMD_STOP_AXE_ID = 100
ICNC_MB_CMD_STOP_AXES = 101
ICNC_MB_CMD_MOVE_SPEED = 102
ICNC_MB_CMD_MOVE_AXE = 103
ICNC_MB_CMD_MOVE_AXE_RELATIF = 104
ICNC_MB_CMD_SET_POSITION = 105
ICNC_MB_CMD_HOME = 106
ICNC_MB_CMD_PROBE = 107
ICNC_MB_CMD_PROBE_MASK = 108
ICNC_MB_CMD_PUT_PLCBASIC_CMD = 200


ICNC_GRBL_GCODE_STRING__CMD = 1000
ICNC_GRBL_SET_FEEDRATE_CMD = 1001
ICNC_GRBL_MOVETO_CMD = 1002
ICNC_GRBL_MOVE_CIRCULAR_IJ_CMD = 1003
ICNC_GRBL_BUFF_ACTION_CMD = 1010
ICNC_GRBL_DWELL_CMD = 1011
ICNC_WAIT_INPUT_BUFCMD = 1012
ICNC_GRBL_SET_OVERRIDE_CMD = 1100
ICNC_GRBL_GO_HOME = 1110
ICNC_GRBL_DIRECT_CMD = 1200



#Const de test
MAX_AXES = 6
MIN_ACCEL_DECEL = 1
MAX_ACCEL_DECEL = 1000000
MAX_SPEED = 1000000
MAX_INPUT_PORT = 32
MAX_OUTPUT_PORT = 12
MAX_DAC = 8
FAST_MOVE = (1 << 6)

#endregion

# region Convertions


def convert_RegistersToFloat(data):

    raw = struct.pack(">HH", data[1], data[0])  # from two unsigned shorts
    res = struct.unpack(">f", raw)[0]
    return res

def convert_RegistersToInt(data):

    raw = struct.pack(">HH", data[1], data[0])  # from two unsigned shorts
    res = struct.unpack(">i", raw)[0]
    return res



def convert_FloatToRegeisters(fvalue):
    x=struct.pack(">f", fvalue)
    data=struct.unpack(">HH", x)
    
    data1=[data[1],data[0]]
  
    return data1



def convert_IntToRegistres(value):
    x=struct.pack(">i", value)
    data=struct.unpack(">HH", x)
   
    data1=[data[1],data[0]]
    return data1

def convert_StringToRegistres(st):
    y=' '.join(format(x, '08b') for x in bytearray(st, 'utf-8'))
    y=y.replace(" ", "")
    lenn=len(y)/16
    length=ceil(lenn)
    data=[0]*len(st)
    index=0
    debut=0
    for i in range(1,len(st)+1,1):
        
            binairy=y[debut:i*8]
            f=int(binairy,2)
            data[index]=f

            index += 1
            debut += 8
    returndata=[0]*int(len(st)/2+len(st)%2)
    for i in range(len(returndata)):
        returndata[i]=data[i*2]
        if (i*2+1<len(data)):
            returndata[i]=returndata[i] |(data[i*2+1]<<8)

    return returndata
# endregion

# region Get/set Param

##Read a single setings regesters (Float value)
##<param name="ParameterNumber"></param> from 1 to 1999
##<param name="fvalue"></param>
def ICNC3_GetParameterFloat(ParameterNumber):
    data = client.read_holding_registers((32000 + (ParameterNumber * 2)), 2)
    data1 = [0, 0]
    data1[0] = data.registers[0]
    data1[1] = data.registers[1]
    res=convert_RegistersToFloat(data1)
    return res

##Read a single setings regesters 
##<param name="ParameterNumber"></param> from 1 to 1999
##<param name="ivalue"></param>
def ICNC3_GetParameter32bits(ParameterNumber):
    data = client.read_holding_registers((32000 + (ParameterNumber * 2)), 2)
    data1 = [0, 0]
    data1[0] = data.registers[0]
    data1[1] = data.registers[1]
    res=convert_RegistersToInt(data1)
    return res

##Write a single setings regesters 
##<param name="ParameterNumber"></param> from 1 to 1999
##<param name="ivalue"></param>
def ICNC3_SetParameter32bits(ParameterNumber, value):
    data = convert_IntToRegistres(value)
    
    client.write_registers((32000 + (ParameterNumber * 2)), data)

## Write a single setings regesters (Float value)
##<param name="ParameterNumber"></param> from 1 to 1999
##<param name="fvalue"></param>
def ICNC3_SetParameterFloat(ParameterNumber, fvalue):
    data = convert_FloatToRegeisters(fvalue)
    
    client.write_registers((32000 + (ParameterNumber * 2)), data)

# endregion

#region tests
def RangeCheck(value, min, max):
   
     if (value > max):
         return -1
     if (value < min):
         return -1
     return 1

def is_axeValid(axeID):
   
     return RangeCheck(axeID, 1, MAX_AXES)

def IS_ACCEL_VALID(accel):
        
     return RangeCheck(accel, MIN_ACCEL_DECEL, MAX_ACCEL_DECEL)

def IS_DECCEL_VALID(deccel):
        
     return RangeCheck(deccel, MIN_ACCEL_DECEL, MAX_ACCEL_DECEL)

def IS_SPEED_VALID(speed):
        
     return RangeCheck(speed, -MAX_SPEED, MAX_SPEED)

def IS_INPUT_VALID(DINNumber):
        
     return RangeCheck(DINNumber, 0, MAX_INPUT_PORT * 8 - 1);

def IS_OUTPUT_VALID( DOUTNumber):
        
     return RangeCheck(DOUTNumber, 0, MAX_OUTPUT_PORT * 8 - 1)

def IS_ANALOG_OUTPUT_VALID(AOUTNumber):
        
     return RangeCheck(AOUTNumber, 0, MAX_DAC * 8 - 1)

def IS_PARAMETERID_VALID(ParameterNumber):
        
      return RangeCheck(ParameterNumber, 1, 1999)

        

#endregion 

#region  Non bufferized Axes related commands

# Stop one Axe
##<param name="axeID"></param> from 1 to 6
def ICNC3_StopAxeID(axeID):
    res=is_axeValid(axeID)
    if(res==-1):
        return
    data = [0,0]
    data[0] = ICNC_MB_CMD_STOP_AXE_ID
    data[1] = axeID
    
    client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data)

# Stop All Axes
##<param name="axeID"></param> axeID = 0x01 to 0x3F
def ICNC3_StopAxes( axeID):
    
    data=[0,0]
    data[0] = ICNC_MB_CMD_STOP_AXES
    data[1] = axeID

    client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data)

# Move one axe to a target
##<param name="AxeID"></param> 1 to 6
##<param name="AccelHz"></param>
##<param name="SpeedHz"></param>
##<param name="DecelHz"></param>
##<param name="TargetStep"></param> 
def ICNC3_MoveAxeAsync(AxeID, AccelHz, SpeedHz, DecelHz, TargetStep):
        

           

            res=is_axeValid(AxeID)
            if(res==-1):
                    return
            res=IS_ACCEL_VALID(AccelHz)
            if(res==-1):
                    return
            res=IS_DECCEL_VALID(DecelHz)  
            if(res==-1):
                    return
            res=IS_SPEED_VALID(SpeedHz)
            if(res==-1):
                    return

            

            data=[0,0,0,0,0,0,0,0,0,0]

            data[0] = ICNC_MB_CMD_MOVE_AXE
            data[1] = AxeID
            two_int = convert_IntToRegistres(AccelHz)
            data[2] = two_int[0]
            data[3] = two_int[1]
            two_int = convert_IntToRegistres(SpeedHz)
            data[4] = two_int[0]
            data[5] = two_int[1]
            two_int = convert_IntToRegistres(DecelHz)
            data[6] = two_int[0]
            data[7] = two_int[1]
            two_int = convert_IntToRegistres(TargetStep)
            data[8] = two_int[0]
            data[9] = two_int[1]

            client.write_registers(REG_HOLDING_START, data)

#move one axe with givnen speed
##<param name="axeID"></param> 1 to 6
##<param name="accel_decel"></param> acceleration and decceleration value
##<param name="speed"></param>
def ICNC3_MoveSpeed( axeID,  accel_decel,  speed):
        
            


            res=is_axeValid(axeID)
            if(res==-1):
                    return
            res=IS_ACCEL_VALID(accel_decel)
            if(res==-1):
                    return
            res=IS_SPEED_VALID(speed)
            if(res==-1):
                    return

            data=[0,0,0,0,0,0]
            data[0] = ICNC_MB_CMD_MOVE_SPEED
            data[1] = axeID
            two_int = convert_IntToRegistres(accel_decel)
            data[2] = two_int[0]
            data[3] = two_int[1]
            two_int = convert_IntToRegistres(speed)
            data[4] = two_int[0]
            data[5] = two_int[1]

            client.write_registers(REG_HOLDING_START, data)

#Homing
##<param name="AxeID"></param> 1 to 6
##<param name="HomingMode"></param>  HomingMode not used at this time
##<param name="InputNumber"></param>
##<param name="ExceptedInputState"></param> 0 if DIN=0 when switch is pressed (NC contact type)
##<param name="Direction"></param>  >0 for positive direction, <=0 for neative direction
##<param name="HighSpeed"></param>
##<param name="LowSpeed"></param>
##<param name="Acceleration"></param> acceleration
##<param name="Deceleration"></param>decceleration
##<param name="StrokeLimitStep"></param>
##<param name="ReverseTimer"></param>
##<param name="HomePositionStep"></param>
##<param name="ClearanceStep"></param>
def ICNC3_HomeAxe(AxeID,HomingMode,InputNumber,ExceptedInputState,Direction,HighSpeed,LowSpeed,Acceleration,Deceleration,StrokeLimitStep,ReverseTimer,HomePositionStep,ClearanceStep):


            res=is_axeValid(AxeID)
            if(res==-1):
                    return
            res=IS_ACCEL_VALID(Acceleration)
            if(res==-1):
                    return
            res=IS_DECCEL_VALID(Deceleration)  
            if(res==-1):
                    return
            res=IS_SPEED_VALID(HighSpeed)
            if(res==-1):
                    return
           

            data=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
            data[0] = ICNC_MB_CMD_HOME
            data[1] = AxeID
            data[2] = HomingMode
            data[3] = InputNumber
            data[4] = ExceptedInputState
            data[5] = Direction
            two_int = convert_IntToRegistres(HighSpeed)
            data[6] = two_int[0]
            data[7] = two_int[1]
            two_int = convert_IntToRegistres(LowSpeed)
            data[8] = two_int[0]
            data[9] = two_int[1]
            two_int = convert_IntToRegistres(Acceleration)
            data[10] = two_int[0]
            data[11] = two_int[1]
            two_int = convert_IntToRegistres(Deceleration)
            data[12] = two_int[0]
            data[13] = two_int[1]
            two_int = convert_IntToRegistres(StrokeLimitStep)
            data[14] = two_int[0]
            data[15] = two_int[1]
            data[16] = ReverseTimer
            two_int = convert_IntToRegistres(HomePositionStep)
            data[17] = two_int[0]
            data[18] = two_int[1]
            two_int = convert_IntToRegistres(ClearanceStep)
            data[19] = two_int[0]
            data[20] = two_int[1]

            client.write_registers(REG_HOLDING_START, data)

##Probe Axe
##<param name="AxeID"></param> 1 to 6
##<param name="InputNumber"></param>
##<param name="ExceptedInputState"></param> 0 if DIN=0 when switch is pressed (NC contact type)
##<param name="Acceleration"></param>
##<param name="Speed"></param>
##<param name="Deceleration"></param>
##<param name="StrokeLimitStep"></param> StrokeLimitStep is positive for positive direction, negative for negative direction
def ICNC3_ProbeAxe(AxeID,InputNumber,ExceptedInputState,Acceleration,Speed,Deceleration,StrokeLimitStep):


            res=is_axeValid(AxeID)
            if(res==-1):
                    return
            res=IS_ACCEL_VALID(Acceleration)
            if(res==-1):
                    return
            res=IS_DECCEL_VALID(Deceleration)  
            if(res==-1):
                    return
            res=IS_SPEED_VALID(Speed)
            if(res==-1):
                    return
            res=IS_INPUT_VALID(InputNumber)
            if(res==-1):
                    return
              
            data=[0,0,0,0,0,0,0,0,0,0,0,0]
            data[0] = ICNC_MB_CMD_PROBE
            data[1] = AxeID
            data[2] = InputNumber
            data[3] = ExceptedInputState
            two_int = convert_IntToRegistres(Acceleration)
            data[4] = two_int[0]
            data[5] = two_int[1]
            two_int = convert_IntToRegistres(Speed)
            data[6] = two_int[0]
            data[7] = two_int[1]
            two_int = convert_IntToRegistres(Deceleration)
            data[8] = two_int[0]
            data[9] = two_int[1]
            two_int = convert_IntToRegistres(StrokeLimitStep)
            data[10] = two_int[0]
            data[11] = two_int[1]

            client.write_registers(REG_HOLDING_START, data)

##Probe Axe With Mask
##<param name="AxeID"></param> 1 to 6
##<param name="ANDMask"></param>
##<param name="XORMask"></param>
##<param name="Acceleration"></param>
##<param name="Speed"></param>
##<param name="Deceleration"></param>
##<param name="StrokeLimitStep"></param>
def ICNC3_ProbeAxeWithMask(AxeID,ANDMask,XORMask,Acceleration,Speed,Deceleration,StrokeLimitStep):
            res=is_axeValid(AxeID)
            if(res==-1):
                    return
            res=IS_ACCEL_VALID(Acceleration)
            if(res==-1):
                    return
            res=IS_DECCEL_VALID(Deceleration)  
            if(res==-1):
                    return
            res=IS_SPEED_VALID(Speed)
            if(res==-1):
                    return
            data=[0,0,0,0,0,0,0,0,0,0,0,0,0,0]
            data[0] = ICNC_MB_CMD_PROBE_MASK
            data[1] = AxeID
            two_int = convert_IntToRegistres(ANDMask)
            data[2] = two_int[0]
            data[3] = two_int[1]
            two_int = convert_IntToRegistres(XORMask)
            data[4] = two_int[0]
            data[5] = two_int[1]
            two_int = convert_IntToRegistres(Acceleration)
            data[6] = two_int[0]
            data[7] = two_int[1]
            two_int = convert_IntToRegistres(Speed)
            data[8] = two_int[0]
            data[9] = two_int[1]
            two_int = convert_IntToRegistres(Deceleration)
            data[10] = two_int[0]
            data[11] = two_int[1]
            two_int = convert_IntToRegistres(StrokeLimitStep)
            data[12] = two_int[0]
            data[13] = two_int[1]

            client.write_registers(REG_HOLDING_START, data)

##Direct write on axes position register
##<param name="AxeID"></param> 1 to 6
##<param name="StepPosition"></param>
def ICNC3_SetPosition( AxeID,  StepPosition):
            res=is_axeValid(AxeID)
            if(res==-1):
                    return
            data=[0,0,0,0]

            data[0] = ICNC_MB_CMD_SET_POSITION;
            data[1] = AxeID
            two_int = convert_IntToRegistres(StepPosition)
            data[2] = two_int[0]
            data[3] = two_int[1]

            client.write_registers(REG_HOLDING_START, data)

#endregion

#region Non bufferized IO related commands

## Set Digital output state
## <param name="OutputNumber"></param> OutputNumbre from 0 to MAX_OUTPUT_PORT*8-1
## <param name="value"></param>Value : 0 for reset, other value for set
def ICNC3_SetOutput( OutputNumber,value):
            res=IS_OUTPUT_VALID(OutputNumber)
            if(res==-1):
                    return
            client.write_coil(MB_COIL_ADDR_OUTPUT0+OutputNumber,value)

##Set Analog Output output Value
##<param name="AnalogOutputNumber"></param> 0 or 1
##<param name="value"></param>0 to 10000
def ICNC3_SetAnalogOutput(  AnalogOutputNumber,  value):
            res=IS_ANALOG_OUTPUT_VALID(AnalogOutputNumber)
            if(res==-1):
                    return
            client.write_register(MB_HOLD_ADDR_AOUT0 + AnalogOutputNumber,value)

#endregion

#region Interact command with CNC process

##Send a direct non-bufferised command
##<param name="Command"></param>
def ICNC3_CNCDirectCommand(Command):
            data=[0,0]
            data[0] = ICNC_GRBL_DIRECT_CMD
            data[1] = Command
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

##Define override value( Value are pourcentage of speed setting)
##<param name="NormalOverride_pct"></param> NormalOverride_pct is related to the feed override previously define with ICNC3_SetFeedRate command
##<param name="RapidOverride_pct"></param>RapidOverride_pct is related to the maximum speed
def CNC3_CNCSetOverride(NormalOverride_pct,RapidOverride_pct):
            data=[0,0,0]
            data[0] = ICNC_GRBL_SET_OVERRIDE_CMD
            data[1] = NormalOverride_pct
            data[2] = RapidOverride_pct
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

##Start automatic homing sequence difine by parameters
##<param name="ctx"></param>Modbus Connection
##<param name="AxeID"></param>AxeID = 0 to 6 / if AxeID=0, start the full sequence
##For other value, launch individual axis sequence
def ICNC3_StartHomingSequence(AxeID):
            data=[0,0]
            data[0] = ICNC_GRBL_GO_HOME
            data[1] = AxeID & 0x3f
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

#endregion 

#region Commandes CNC bufferises

##Send a Gcode line directly
##<param name="GCodeStr"></param> Gcode line (string) separator signe "."
def ICNC3_PushGCode( GCodeStr):
   
            registerRequired = int((len(GCodeStr) + 1) / 2)
            data =[0]*(registerRequired + 2)
            strigg =[0]* registerRequired

            data[0] = ICNC_GRBL_GCODE_STRING__CMD;
            data[1] = len(GCodeStr)
            strigg = convert_StringToRegistres(GCodeStr)
            for i in range(registerRequired):
           
                data[i + 2] = strigg[i];
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data)

            return

##Send a Command(string) it need to end by "\n"
##<param name="strCommand"></param> Command (string) ex:"out 1,1\n"
def ICNC3_SendPLCCommand( strCommand):
     registerRequired = int((len(strCommand)+1) / 2);
     data=[0]*(registerRequired+2)
     data[0] = ICNC_MB_CMD_PUT_PLCBASIC_CMD;
     data[1] = len(strCommand);
     strigg = convert_StringToRegistres(strCommand);
     for i in range(registerRequired):
         data[i + 2] = strigg[i]
     client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data)

     return

 ##Adjust feed rate for following bufferized motion
##<param name="feed_rate_mm_per_mn"></param>
def ICNC3_PushSetFeedRate( feed_rate_mm_per_mn):
            data=[0,0,0]
            data[0] = ICNC_GRBL_SET_FEEDRATE_CMD
            two_int = convert_FloatToRegeisters(feed_rate_mm_per_mn)
            data[1] = two_int[0]
            data[2] = two_int[1]
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data)

##Send a movement
##<param name="AxesFlag"></param> axe1 = lsb 
def ICNC3_PushMoveTo( AxesFlag,  RapidMove,  x,  y,  z,  a,  b,  c):
    
            data= [0,0,0,0,0,0,0,0,0,0,0,0,0,0]
            data[0] = ICNC_GRBL_MOVETO_CMD
            data[1] =(AxesFlag & 0x3F)

            index = 2
            if (RapidMove > 0):
                data[1] |= FAST_MOVE
            if ((AxesFlag & (1 << 0)) != 0):
                two_int = convert_FloatToRegeisters(x);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 1)) != 0):
            
                two_int = convert_FloatToRegeisters(y);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 2)) != 0):
            
                two_int = convert_FloatToRegeisters(z);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 3)) != 0):
            
                two_int = convert_FloatToRegeisters(a);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 4)) != 0):
            
                two_int = convert_FloatToRegeisters(b);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 5)) != 0):
            
                two_int = convert_FloatToRegeisters(c);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            data1=[0]*index
            for i in range(index):
                    data1[i] = data[i]
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data1)    

##Send a movement
##<param name="Direction"></param> 0=CW / 1 =CCW
def ICNC3_PushCircleCommon(  Direction,  x,  y,  I,  J):
            data=[0,0,0,0,0,0,0,0,0,0]
            data[0] = ICNC_GRBL_MOVE_CIRCULAR_IJ_CMD;
            data[1] = Direction;      # 0 for CW direction, 1 for CCW direction
            two_int = convert_FloatToRegeisters(x);
            data[2] = two_int[0]
            data[3] = two_int[1]
            two_int = convert_FloatToRegeisters(y);
            data[4] = two_int[0]
            data[5] = two_int[1]
            two_int = convert_FloatToRegeisters(I);
            data[6] = two_int[0]
            data[7] = two_int[1]
            two_int = convert_FloatToRegeisters(J);
            data[8] = two_int[0]
            data[9] = two_int[1]
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data)   

def ICNC3_PushCircleCW( x,  y,  I,  J):
        

            return ICNC3_PushCircleCommon( 0, x, y, I, J)


def ICNC3_PushCircleCCW(  x,  y,  I,  J):
        
            return ICNC3_PushCircleCommon(1, x, y, I, J);

##Add delay (ms) into then command buffer
##<param name="delay_ms"></param>        
def  ICNC3_PushDelay(  delay_ms):
      

            data=[0,0]
            data[0] = ICNC_GRBL_DWELL_CMD
            data[1] =delay_ms    
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data) 

##common function used to push action into modbus buffer
##<param name="ctx"></param>Modbus Connection
##<param name="ActionType"></param> functions below and Action type 1 for DOUT, 2 for AOUT, 3 for holding register
##<param name="Adress"></param>  ex:DOutNumber,AOutNumber,HoldingAddress ...
##<param name="Value"></param>
def ICNC3_PushActionCommon(  ActionType,  Adress,  Value):
        
            data=[0,0,0,0]
            data[0] = ICNC_GRBL_BUFF_ACTION_CMD
            data[1] = ActionType
            data[2] = Adress
            data[3] = Value
            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0, data) 

##Add digital output set state in command buffer
def ICNC3_PushActionDOUT(  DOutNumber,  Value):
            res=IS_OUTPUT_VALID(DOutNumber)
            if(res==-1):
                    return
            ICNC3_PushActionCommon(1, DOutNumber, Value)

##Add analog output set value in command buffer
def ICNC3_PushActionAOUT( AOutNumber,  Value):
            res=IS_ANALOG_OUTPUT_VALID(AOutNumber)
            if(res==-1):
                    return
            ICNC3_PushActionCommon(2, AOutNumber, Value)

##Add Modbus Holding Register set value in command buffer
def ICNC3_PushActionRegister( HoldingAddress,  Value):

    ICNC3_PushActionCommon(3, HoldingAddress, Value)

##  Add Modbus THC activation with auto tune of target voltage  in command buffer 
##THC function is delayed and start after a timer (parameter 1351, type float, unit second),
##Then, THC regulation start with target voltage define in Holding register . 
##Target voltage have to be define before but can be change on the fly
##Registre 2444, 32 bits, unit mV	
##While THC is ON, Z axis is locked and can't be control by external command
def ICNC3_PushActionTHCOn():

    ICNC3_PushActionCommon( 4, 0, 0)

## Add Modbus THC activation with auto tune of target voltage  in command buffer 
## <param name="SamplingTime"></param>Then sampling and average is done for SamplingTime period
##THC function is delayed and startafter a timer(parameter 1351, type float, unit second),
##Then, THC regulation start with target voltage previously measured.
##Voltage result of measurement is stored into Holding register 2444 (32 bits, unit mV) and can be change on the fly
##While THC is ON, Z axis is locked and can't be control by external command
def ICNC3_PushActionTHCOnAuto(  SamplingTime):

    ICNC3_PushActionCommon( 5, SamplingTime, 0)

##Add Modbus THC Off in command buffer
def ICNC3_PushActionTHCOff():

    ICNC3_PushActionCommon( 6, 0, 0)

## Add Modbus THC Pause in command buffer
## Pause THC while result of stop Z axis and disable regulation.
##It can be use to disable the THC in some portion of trajectory 
def ICNC3_PushActionTHCPause():

    ICNC3_PushActionCommon( 7, 0, 0)

## Add Modbus THC Resume in command buffer
## Resume THC will re-activate the regulation after a pause
def ICNC3_PushActionTHCResume():

    ICNC3_PushActionCommon( 8, 0, 0)

##Add wait event on digital input into then command buffer
##<param name="DIN_EventType"></param>  1 for rising, 2 for falling, 3 for high, 4 for low
def ICNC3_PushWaitForDINEvent(  DIN_EventType,  DIN_number,  Timeout_action,  timeout_value_ms):

            data=[0,0,0,0,0,0]
            data[0] = ICNC_WAIT_INPUT_BUFCMD   #Wait event modbus command
            data[1] = 1    #Action type 1 for wait input state
            data[2] = timeout_value_ms
            data[3] = Timeout_action
            data[4] = DIN_EventType
            data[5] = DIN_number

            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

##Add wait event on analog input input into then command buffer
##<param name="AIN_EventType"></param> 1 for higher than, 2 lower than, 3 for equal
def ICNC3_PushWaitForAINEvent( AIN_EventType,  AIN_number,  AIN_value,  Timeout_action,  timeout_value_ms):

            data=[0,0,0,0,0,0,0]
            data[0] = ICNC_WAIT_INPUT_BUFCMD
            data[1] = 2   # Action type 2 for wait analog input value
            data[2] = timeout_value_ms
            data[3] = Timeout_action
            data[4] = AIN_EventType
            data[5] = AIN_value
            data[6] = AIN_number

            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

##Add wait event on modbus variabme (using extended adress type) into then command buffer
##<param name="ModbusData_EventType"></param>1 for higher than, 2 lower than, 3 for equal
def ICNC3_PushWaitForRegisterEvent(  ModbusData_EventType,  ExtendedModbusAddress,  ModbusVariableValue,  Timeout_action,  timeout_value_ms):

            data=[0,0,0,0,0,0,0,0]
            data[0] = ICNC_WAIT_INPUT_BUFCMD
            data[1] = 3   # Action type 3 for wait extended modbus variable 
            data[2] = timeout_value_ms
            data[3] = Timeout_action
            data[4] = ModbusData_EventType
            data[5] = ModbusVariableValue
            two_int = convert_IntToRegistres(ExtendedModbusAddress)
            data[6] = two_int[0]
            data[7] = two_int[1]

            client.write_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

#endregion



#region GUI
root =Tk()
root.geometry("800x200")
root.title("ICNC3 Comunication Modbus")


Axe=Entry(root)
Speed=Entry(root)
Accel=Entry(root)
Decel=Entry(root)
Target=Entry(root)
DirectCommande=Entry(root)
DirectCommande.grid(column=1,row=0)
DirectCommande.delete(0, 'end')
DirectCommande.insert(0,"Commande")
IP=Entry(root)
IP.grid(column=4,row=0)
IP.delete(0, 'end')
IP.insert(0,"192.168.10.236")

def setpos():
    Axe.grid_remove()
    Speed.grid_remove()
    Accel.grid_remove()
    Decel.grid_remove()
    Target.grid_remove()
    ActionMoveAxe.grid_remove()
    ActionMoveSpeed.grid_remove()
    Axe.grid(column=1,row=4)
    Accel.grid(column=2,row=4)
    ActionSetpos.grid(column=3,row=4)
    Axe.delete(0, 'end')
    Accel.delete(0, 'end')
    Axe.insert(0,"numero Axe")
    Accel.insert(0,"Pos")
   

def setpose1(axe,pos):
    ActionSetpos.grid_remove()
    Axe.grid_remove()
    Speed.grid_remove()
    Accel.grid_remove()
    Decel.grid_remove()
    Target.grid_remove()

    try:ICNC3_SetPosition(int(axe),int(pos))
    except:messagebox.showinfo("Erreur","sesie invalid")

    
def directcommande(commande):
    commmmm=commande +"\n"
    try:ICNC3_SendPLCCommand(commmmm)
    except:messagebox.showinfo("Erreur","sesie invalid")


def stopaexs():
    ICNC3_StopAxes(0x3F)




def movespeed():
    ActionSetpos.grid_remove()
    Axe.grid_remove()
    Speed.grid_remove()
    Accel.grid_remove()
    Decel.grid_remove()
    Target.grid_remove()
    ActionMoveAxe.grid_remove()
    Axe.grid(column=1,row=2)
    Accel.grid(column=2,row=2)
    Speed.grid(column=3,row=2)
    ActionMoveSpeed.grid(column=4,row=2)
    Axe.delete(0, 'end')
    Speed.delete(0, 'end')
    Accel.delete(0, 'end')
    Axe.insert(0,"numero Axe")
    Speed.insert(0,"Speed")
    Accel.insert(0,"Accel")
    

def movespeed1(axe,accel, speed):
     
     Axe.grid_remove()
     Speed.grid_remove()
     Accel.grid_remove()
     ActionMoveSpeed.grid_remove()
     try:ICNC3_MoveSpeed(int(axe),int(accel),int(speed))
     except:messagebox.showinfo("Erreur","sesie invalid")

def moveaxe():
     ActionSetpos.grid_remove()
     ActionMoveSpeed.grid_remove()
     Axe.grid(column=1,row=3)
     Accel.grid(column=2,row=3)
     Speed.grid(column=3,row=3)
     Decel.grid(column=4,row=3)
     Target.grid(column=5,row=3)
     ActionMoveAxe.grid(column=6,row=3)

     Axe.delete(0, 'end')
     Speed.delete(0, 'end')
     Accel.delete(0, 'end')
     Decel.delete(0, 'end')
     Target.delete(0, 'end')
     Axe.insert(0,"numero Axe")
     Speed.insert(0,"Speed")
     Accel.insert(0,"Accel")
     Decel.insert(0,"Decel")
     Target.insert(0,"Target")
     
     
def moveaxe1(axe,accel,speed,decel,target):

     Axe.grid_remove()
     Speed.grid_remove()
     Accel.grid_remove()
     Decel.grid_remove()
     Target.grid_remove()
     ActionMoveAxe.grid_remove()

     try:ICNC3_MoveAxeAsync(int(axe),int(accel),int(speed),int(decel),int(target))
     except:messagebox.showinfo("Erreur","sesie invalid")


MoveSpeed=Button(root,text="MoveSpeed",  height=1, width=16,command=movespeed )
MoveSpeed.grid(column=0,row=2)
MoveSpeed.config(state=DISABLED)
MoveAxe=Button(root,text="MoveAxe",height=1, width=16,command=moveaxe)
MoveAxe.grid(column=0,row=3)
MoveAxe.config(state=DISABLED)
setposs=Button(root,text="SetPos",height=1, width=16,command= setpos)
setposs.grid(column=0,row=4)
setposs.config(state=DISABLED)
StopAxes=Button(root,text="Stop Axes",height=1, width=16,command=stopaexs)
StopAxes.grid(column=0,row=1)
StopAxes.config(state=DISABLED)


ActionMoveSpeed=Button(root,text="Action",command=lambda:movespeed1(Axe.get(),Accel.get(), Speed.get()))

ActionMoveAxe=Button(root,text="Action",command=lambda:moveaxe1(Axe.get(),Accel.get(), Speed.get(),Decel.get(),Target.get()))

ButtonDirectCommande=Button(root,text="Action",command=lambda:directcommande(DirectCommande.get()))
ButtonDirectCommande.grid(column=2,row=0)
ButtonDirectCommande.config(state=DISABLED)
ActionSetpos=Button(root,text="Action",command=lambda:setpose1(Axe.get(),Accel.get()))
Lable1 =  Label(root,text="Direct CMD")
Lable1.grid(column=0,row=0)
Lable2 =Label(root,text="Not Connected")
Lable2.config(bg="red")
Lable2.grid(column=3,row=0)

Axe1 =  Label(root,text="Axe 1")
Axe1.grid(column=0,row=5)
Axe2 =  Label(root,text="Axe 2")
Axe2.grid(column=1,row=5)
Axe3 =  Label(root,text="Axe 3")
Axe3.grid(column=2,row=5)
Axe4 =  Label(root,text="Axe 4")
Axe4.grid(column=3,row=5)
Axe5 =  Label(root,text="Axe 5")
Axe5.grid(column=4,row=5)
Axe6 =  Label(root,text="Axe 6")
Axe6.grid(column=5,row=5)
posaxe1=Entry(root)
posaxe2=Entry(root)
posaxe3=Entry(root)
posaxe4=Entry(root)
posaxe5=Entry(root)
posaxe6=Entry(root)
posaxe1.grid(column=0,row=6)
posaxe2.grid(column=1,row=6)
posaxe3.grid(column=2,row=6)
posaxe4.grid(column=3,row=6)
posaxe5.grid(column=4,row=6)
posaxe6.grid(column=5,row=6)
posaxe1.config(state=DISABLED)
posaxe2.config(state=DISABLED)
posaxe3.config(state=DISABLED)
posaxe4.config(state=DISABLED)
posaxe5.config(state=DISABLED)
posaxe6.config(state=DISABLED)



data=[0]*12  
data1=[0]*12



ok=0

def updatePos():
   
    if (ok==1):
        if(client.connect()==True):
            try:data=client.read_input_registers(1030,12)    
            except:messagebox.showinfo("Erreur","IP invalid")
            for i in range(12):
                data1[i] = data.registers[i]
            
            x=convert_RegistersToInt(data1[0:2])
            y=convert_RegistersToInt(data1[2:4])
            z=convert_RegistersToInt(data1[4:6])
            a=convert_RegistersToInt(data1[6:8])
            b=convert_RegistersToInt(data1[8:10])
            c=convert_RegistersToInt(data1[10:12])
            posaxe1.config(state="normal")
            posaxe2.config(state="normal")
            posaxe3.config(state="normal")
            posaxe4.config(state="normal")
            posaxe5.config(state="normal")
            posaxe6.config(state="normal")
            posaxe1.delete(0, 'end')
            posaxe2.delete(0, 'end')
            posaxe3.delete(0, 'end')
            posaxe4.delete(0, 'end')
            posaxe5.delete(0, 'end')
            posaxe6.delete(0, 'end')
            posaxe1.insert(0,x)
            posaxe2.insert(0,y)
            posaxe3.insert(0,z)
            posaxe4.insert(0,a)
            posaxe5.insert(0,b)
            posaxe6.insert(0,c)
            posaxe1.config(state=DISABLED)
            posaxe2.config(state=DISABLED)
            posaxe3.config(state=DISABLED)
            posaxe4.config(state=DISABLED)
            posaxe5.config(state=DISABLED)
            posaxe6.config(state=DISABLED)
            root.after(100, updatePos)  
    else:
        root.after(100, updatePos)  
client =0
def connection(ip):
    global client
    global ok
    
    client = ModbusClient(ip, 502)
       
   
    if(client.connect()==True):
        ok=1
        Lable2.config(bg="green")
        Lable2.config(text="Connected")
        MoveSpeed.config(state="normal")
        ButtonDirectCommande.config(state="normal")
        StopAxes.config(state="normal")
        setposs.config(state="normal")
        MoveAxe.config(state="normal")
    else:
        
        ok=0
        Lable2.config(bg="red")
        Lable2.config(text="Not Connected")
        posaxe1.insert(0,0)
        posaxe2.insert(0,0)
        posaxe3.insert(0,0)
        posaxe4.insert(0,0)
        posaxe5.insert(0,0)
        posaxe6.insert(0,0)
        MoveSpeed.config(state=DISABLED)
        ButtonDirectCommande.config(state=DISABLED)
        StopAxes.config(state=DISABLED)
        setposs.config(state=DISABLED)
        MoveAxe.config(state=DISABLED)
        messagebox.showinfo("Erreur","IP invalid")


Buttonconnection=Button(root,text="Connect",command=lambda:connection(IP.get()))
Buttonconnection.grid(column=5,row=0)


schedule.run_pending()
#time.sleep(1)

root.after(100, updatePos)
root.mainloop()  



#endregion